-- Main
--by @jmv38
-- This part is not part of the tutorial, it is managing the transitions
-- => the code is not commented

function setup()
    supportedOrientations(LANDSCAPE_LEFT)
    -- the demo tabs
    demo = listProjectTabs()
    -- remove the last tabs starting at Main tab
    local thisIsNoDemoTab = false
    for i = 1,#demo do 
        if demo[i] == "Main" then thisIsNoDemoTab = true end
        if thisIsNoDemoTab then demo[#demo] = nil end
    end

    print("Swipe left/right to go to next demo tab")
    print("Or use the top right selector to jump quickly to a demo tab")
    
    -- I use 2 images to make the transition between demos smoother, and for the workbench
    img1 = image(WIDTH,HEIGHT)
    img2 = image(WIDTH,HEIGHT)
    position = {dx1=0,dx2=WIDTH}    -- a table to keep the image position
    message = ""       -- some text to display
    touchable = true   -- flag to disable touch during transitions
    
    -- a quick browsing slider
    slider = Slider({list=demo, x=WIDTH-160, y=HEIGHT-200, w=300, h=40, fontSize=20,
        callback = function(i,tab) setTab(i) end})
    -- let's start by running the first tab of the list
    setTab(1)
    -- a screen swipe sensor
    botScreen = {x=0,y=0,w=WIDTH,h=HEIGHT}
    botScreen.sensor = Sensor {parent=botScreen}
    botScreen.sensor:onSwipe(function(event)
        if event.dx < 0 and current<#demo then setTab(current + 1) end
        if event.dx > 0 and current>1 then setTab(current - 1) end
    end)
    -- a screen to sense any touch
    topScreen = {x=0,y=0,w=WIDTH,h=HEIGHT}
    topScreen.sensor = Sensor {parent=topScreen}
    topScreen.sensor.doNotInterceptTouches = true
    touches = {} -- collect touches for the video only
    topScreen.sensor:onTouched(function(event)
        local t = event.touch
        if t.state == BEGAN or t.state == MOVING then
            touches[t.id] = {x=t.x, y=t.y}
        else
            touches[t.id] = nil
        end
    end
    )
end

function setTab(i)
    if not current then current = i currentTab = demo[i] end

    runTab(i)()
    current = i
    currentTab = demo[i]
    slider:setCur(i)
    copyButtonMenu()

end
function copyButtonMenu()
    -- clear
    parameter.clear()
    message = ""
    -- if this is not a demo tab, no copy button
    if currentTab:sub(1,1) == "D" then 
        -- a <copy> button so you can quickly get the tab code
        parameter.action("copy Main and Sensor",function()
            pasteboard.text = "--".."# Main\n"..readProjectTab(currentTab) ..
            "\n".."--".."# Sensor\n"..readProjectTab("Sensor")
            print(currentTab .. " and Sensor have been copied. You can now paste it into a new project.")
        end )
        parameter.action("copy Main code only",function()
            pasteboard.text = readProjectTab(currentTab) 
            print(currentTab .. " copied. You can now paste it into a project.")
        end )
        -- show tab name
        message = currentTab
    end
    if currentTab == "Workbench" then 
        -- a <copy> button so you can quickly get the blendmode
        parameter.action("copy blendmode",function()
            pasteboard.text = blend:tostring()
            print(pasteboard.text)
        end )
    end
end
function mainDraw()
    background(0)
    drawDemo()
    drawMessage()
    slider:draw()
    noStroke()
    fill(255,128)
    for k,t in pairs(touches) do
        ellipse(t.x,t.y,35)
    end
end

function runTab(i)
    local callback = function() 
        -- get tab content
        local name = demo[i]
        local tab = readProjectTab(name)
        -- execute it (calling setup is necessary to setup new values)
        draw = function() end
        touched = function() end
        load(tab)() 
        drawDemo = draw
        touchedDemo = touched
        setup()
        -- draw once into an image, and then re-activate the main draw function
        img2 = draw_into_image()
        -- this is to make a nice transition between demo tabs
        animateTransition(i)
    end
    return callback
end

function animateTransition(new)
    local direction = compare(current,new)
    position.dx1= 0
    position.dx2= WIDTH * direction
    touchable = false
    draw = transitionDraw
    tween(1, position, {dx1= -WIDTH * direction ,dx2=0}, tween.easing.cubicInOut)
    tween.delay(1,function()
        position.dx1=0
        position.dx2=WIDTH
        img1 = img2
        collectgarbage()
        touchable = true
        draw = mainDraw
        touched = mainTouched
    end)
    currentTab = name
end

function transitionDraw()
    -- during transition, 2 fixed images are moved on the screen (no live update)
    background(0)
    spriteMode(CORNER)
    sprite(img1, position.dx1, 0)   -- this image is the main one
    sprite(img2, position.dx2, 0)   -- this one is used for transition effects
end

function compare(v1,v2)
    if v1 < v2  then return 1.0 end
    if v1 == v2 then return 0.0 end
    if v1 > v2  then return -1.0 end
end

function mainTouched(t)
    topScreen.sensor:touched(t) 
    if slider:touched(t) then return true end
    if touchedDemo(t) then return true end
    if botScreen.sensor:touched(t) then return true end
end


function drawMessage()
    if message == "" then return end
    resetStyle()
    fill(128)
    rectMode(CENTER)
    local x,y = WIDTH/2,HEIGHT-50
    rect(x,y,300,50)
    fill(255)
    fontSize(25)
    text(message,x,y)
end

function draw_into_image()
    local img = image(WIDTH,HEIGHT)
    setContext(img)
    draw()
    setContext()
    return img
end